#!/bin/sh
#--
#-- PPD Installation Script
#--

#--
#-- Initialize_Variables helper function.  Depending on the Linux OS, the path
#-- can either be: /usr/bin/command or /bin/command.  So, lets set these 
#-- dynamically.
#--
set_variable()
{
	VAR_NAME="${1}"
	CMD_NAME="${2}"
	if [ -f "/usr/bin/${CMD_NAME}" ];then
		eval ${VAR_NAME}="/usr/bin/${CMD_NAME}"
	elif [ -f "/bin/${CMD_NAME}" ];then
		eval ${VAR_NAME}="/bin/${CMD_NAME}"
	else
		printf "\n---------------------\nInstallation aborted.\n---------------------\n"
		printf "This script uses a set of system commands which may be\n"
		printf "in a different location on your system.\n\n"
		printf "The following system command was not found: /usr/bin/${CMD_NAME}\n\n"
		exit
	fi
}


#--
#-- This script is written in UTF-8, so we need to know if we should display
#-- the NLS characters in Native or UTF-8 Encoding.  So, lets check the
#-- current LANG or LC_CTYPE variables to see if the script is running in
#-- UTF-8 encoded terminal.
#--
set_show_utf8()
{
	${ECHO_CMD} "${LANG} ${LC_CTYPE}" | ${GREP_CMD} -i "UTF-8" >/dev/null 2>&1
	if [ $? -eq 0 ];then
		show_utf8="yes"
	else
		show_utf8="no"
	fi
}


#--
#-- Setup System and Script variables
#--
initialize_variables()
{
	#-- Setup System Variables
	set_variable ID_CMD id
	set_variable GREP_CMD grep 
	set_variable EGREP_CMD egrep 
	set_variable LS_CMD ls
	set_variable DIRNAME_CMD dirname
	set_variable BASENAME_CMD basename
	set_variable PRINTF_CMD printf
	set_variable ECHO_CMD echo
	set_variable CAT_CMD cat 
	set_variable AWK_CMD awk
	set_variable SED_CMD sed
	set_variable PS_CMD ps
	set_variable CHMOD_CMD chmod
	set_variable TR_CMD tr
	set_variable ICONV_CMD iconv 
	set_variable CP_CMD cp
	set_variable RM_CMD rm

	set_show_utf8

	#-- Initialize Script variables
	OEM="f+ imaging"
	
		if [ "${OEM}" = "IPS" ]; then
			MANUFACTURER=""
		else
			MANUFACTURER="${OEM} "
		fi
	URL="http://www.lexmark.com"
	
	FOO_DIR="/usr/share/foomatic/db/source"
	FOO_PRT_DIR="/usr/share/foomatic/db/source/printer"
	FOO_OPT_DIR="/usr/share/foomatic/db/source/opt"
	FOO_DRV_DIR="/usr/share/foomatic/db/source/driver"

		if [ -d "/usr/share/ppd" ]; then
			CUPS_PPD_ROOT="/usr/share/ppd"
		else
			CUPS_PPD_ROOT="/usr/share/cups/model"
		fi
		
		if [ -e "/usr/share/cups/model/0-driverppds" -o -e "/usr/share/cups/model/3-distribution" ]; then
			CUPS_PPD_ROOT="/usr/share/cups/model"
		fi

	CUPS_CONFIG="/usr/bin/cups-config"

		if [ "${OEM}" = "Lexmark" ] || [ "${OEM}" = "Dell" ]; then
			
			OEM_DEST="${OEM}"
		else
			OEM_DEST="Printer"

		fi

	DEST_PPD_DIR="${CUPS_PPD_ROOT}/${OEM_DEST}_PPD"
	STD_PPD_DIR="/usr/share/ppd"
	PPD_PERMS="0664"
	INSTALL_TYPE="1"
	PPD_DEFAULT="1"
	ENCODE_DEFAULT="1"
	LANG_DEFAULT="1"
	DEFAULT_ENCODE="ISO8859-1"
	GLOBALDIR12="GlobalPPD_1.2"
	GLOBALDIR14="GlobalPPD_1.4"
	FAXPNHDIR="Filter"
	DEST_FAX_PNH_DIR="/usr/lib/cups/filter"
	FAXPNHFILTER="fax-pnh-filter"
	REROUTEFILTER="rerouteprintoption"
	HBPFILTER="LexHBPFilter"
	CMDFILEFILTER="CommandFileFilterG2"
        DEST_LEX_CONVS_DIR="/usr/share/cups/mime"
        LEX_CONVS="lexmark.convs"
        CONTONE_FILTERDIR_LIB="lib"
        CONTONE_FILTERDIR_LIB64="lib64"
        CONTONEFILTER="pdftocontone"
        ISCUPS14="true"
        PPD_LINK="NO"
		
	


	PREDEF_FILES="ApeosPort_Print_4020SD ApeosPort_4020SD Sindoh_A640dn Sindoh_LP4044dn Sindoh_M640 Sindoh_MF4044 SHARP_MX-B427PW SHARP_MX-B427W f+_imaging_P40dn_Series f+_imaging_M40adn_Series"
	PREDEF_FILES_FOO="f+_imaging_P40dn_Series SHARP_MX-B427W Sindoh_LP4044dn ApeosPort_Print_4020SD Sindoh_A640dn Sindoh_M640 f+_imaging_M40adn_Series SHARP_MX-B427PW Sindoh_MF4044 ApeosPort_4020SD"

	if [ -f "/etc/SuSE-release" ];then
		SYS_TYPE="SUSE"
		SHOW_FOO="NO"
		SHOW_ENC="YES"
	elif [ -f "/etc/lindowsos-version" -o -f "/etc/linspire-version" ];then
		SYS_TYPE="LINSPIRE"
		SHOW_FOO="NO"
		SHOW_ENC="NO"
		PPD_LINK="YES"
	elif [ -f "/etc/debian_version" ];then
                if [ -f "/etc/lsb-release" ];then
                    SYS_TYPE="UBUNTU"
                else
		    SYS_TYPE="DEBIAN"
                fi
		SHOW_FOO="YES"
		SHOW_ENC="YES"
		PPD_LINK="YES"
		if [ -d "/usr/share/ppd" ];then
			CUPS_PPD_ROOT="/usr/share/ppd"
		fi
	elif [ -f "/etc/fedora-release" ];then
		SYS_TYPE="FEDORA"
		SHOW_FOO="YES"
		SHOW_ENC="YES"
		PPD_LINK="YES"
	elif [ -f "/etc/redhat-release" ];then
		COUT=`${CAT_CMD} /etc/redhat-release`
		SHOW_FOO="YES"
		
		${PRINTF_CMD} "${COUT}\n" | ${GREP_CMD} " 3 " >/dev/null 2>&1
		
		if [ $? -eq 0 ];then
			SYS_TYPE="REDHAT_3"
		else
			${PRINTF_CMD} "${COUT}\n" | ${GREP_CMD} " 4 " >/dev/null 2>&1
			if [ $? -eq 0 ];then
				SYS_TYPE="REDHAT_4"
			else
	                        ${PRINTF_CMD} "${COUT}\n" | ${GREP_CMD} " 5 " >/dev/null 2>&1
				if [ $? -eq 0 ];then
					SYS_TYPE="REDHAT_5"
					SHOW_FOO="NO"
				else
					SYS_TYPE="REDHAT_x"
				fi
			fi
		fi
		SHOW_ENC="YES"
	else
		SYS_TYPE="OTHER"
		SHOW_FOO="YES"
		SHOW_ENC="YES"
	fi
}


#--
#-- Handle running the script outside the package directory
#--
change_to_install_dir()
{
	SCRIPT="${0}"
	if [ -h "${SCRIPT}" ];then
		REAL_SCRIPT="`${LS_CMD} -l ${SCRIPT} 2>/dev/null | ${AWK_CMD} '{ print $NF }'`"
	else
		REAL_SCRIPT="${SCRIPT}"
	fi
	SCRIPT_DIR="`${DIRNAME_CMD} ${REAL_SCRIPT}`"
	if [ ! -d "${SCRIPT_DIR}/foomatic/${DEFAULT_ENCODE}" ];then
		${ECHO_CMD}
		${ECHO_CMD} "Application Error!"
		${ECHO_CMD}
		${ECHO_CMD} "This script (`${BASENAME_CMD} ${SCRIPT}`) should be located in the"
		${ECHO_CMD} "directory were you untarred the package."
		${ECHO_CMD}
		exit
	fi
	cd ${SCRIPT_DIR}
}



select_cups_version(){
${CAT_CMD} - << __END__

----------------------------
Selecting PPD Version
------------- ---------------

Select the appropriate PPD that suits to the 
CUPS version you're using

 1.  Globalized PPD 
     --------------
     Select this option if you are using CUPS 1.2 or higher.

 2.  Localized PPD
     -------------
     Select this option if you're using CUPS 1.2 or does not 
     support globalized PPD.

__END__

${PRINTF_CMD} "Please select the PPD to install (1|2)? : [1] "
read cups


	if [ "${cups}" = "1" ] || [ -z "${cups}" ];then
		globalized="true"
	else
		globalized="false"		
	fi


}



#--
#-- Verify that CUPS PPD Directories are on the system.
#--
check_for_cups()
{
	if [ ! -d "${CUPS_PPD_ROOT}" ];then
		${ECHO_CMD} 
		${ECHO_CMD} "Error:  CUPS PPD directories were not found."
		${ECHO_CMD} "        Either CUPS is not installed or CUPS was installed"
		${ECHO_CMD} "        in a non standard directory."
		${ECHO_CMD}
		${ECHO_CMD} "        If you do have CUPS installed, just copy the PPD files"
		${ECHO_CMD} "        into your CUPS PPD directory and restart CUPS."
		${ECHO_CMD}
		exit 1
	fi

	#./cups12check > /dev/null 2>&1
	#
	#if [ $? -eq 0 ];then	
	#	globalized="true"
	#else
	#	globalized="false"
	#fi


}



#--
#-- Get the Linux OS's CUPS version
#--
get_cups_version()
{
    MACHINE_TYPE_A=`uname -m`
    MACHINE_TYPE_B=`uname -i`

    if [ ${MACHINE_TYPE_A} = 'x86_64' -o ${MACHINE_TYPE_B} = 'x86_64' ]; then
        GlobalPPD_1.4/lib64/cupsversion > /dev/null 2>&1
    else
        GlobalPPD_1.4/lib/cupsversion > /dev/null 2>&1
    fi

    CUPS_VERSION=$?

    if [ $CUPS_VERSION -ge 2 -o "$SHOW_FOO" = "NO" ];then
        globalized="true"
    else
        globalized="false"
    fi
}



#--
#-- Set the appropriate PPD file depending 
#-- on the Linux OS's CUPS version
#--
set_ppd()
{
    if [ $CUPS_VERSION -le 3 ]; then
        GLOBALDIR="${GLOBALDIR12}"
        ISCUPS14="false"
    elif [ $CUPS_VERSION -ge 4 ]; then
        GLOBALDIR="${GLOBALDIR14}"
        ISCUPS14="true"
    fi

    ${RM_CMD} -fr CUPS_VERSION
}



#--
#-- Manage User Answers
#--
confirm_user()
{
	rc=0
	if [ "${1}" != "1" -a "${continue1}" = "yes" ];then
		rc=1
		${ECHO_CMD}
		return ${rc}
	fi
	if [ "${1}" = "1" -a "${continue2}" = "yes" ];then
		${ECHO_CMD}
		${ECHO_CMD} "    AUTOMATIC OVERWRITE"
		rc=1
		return ${rc}
	fi

	if [ "${1}" = "1" ]; then
		${PRINTF_CMD} "       Replace .. (y/n/all/exit) [n]? "
	else
		${PRINTF_CMD} "(n/y/all/exit) [n] "
	fi
	read answer
	${ECHO_CMD}

	if [ "$answer" = "y" -o "$answer" = "yes" ]; then
		rc=1
		return $rc
	elif [ "$answer" = "exit" -o  "$answer" = "e" ]; then
		exit 0
	elif [ "$answer" = "all" -o "$answer" = "a" ]; then
		if [ "$1" = "1" ];then
			continue2=yes
		else
			continue1=yes
		fi
		rc=1
		return $rc
	elif [ "$answer" = "no" -o "$answer" = "n" -o "$answer" = "" ]; then
		rc=0
	else	
		rc=-1
	fi

	return $rc
}

#--
#-- Check for root
#--
check_for_root()
{
	ID=`${ID_CMD}`
	${ECHO_CMD} "${ID}" | ${GREP_CMD} "uid=0" >/dev/null 2>&1
   if [ "${?}" != "0" ]; then 
		${ECHO_CMD}
		${ECHO_CMD} "You must be an administrator to run this program."
		${ECHO_CMD}
		exit 1
	fi
}


display_header()
{
    if [ "${OEM}" = "Lexmark" ];then
        COPYRIGHT=""
    fi

    if [ "${OEM}" = "LG" ];then
        MANUFACTURER=""
    fi
    ${CAT_CMD} - << __END__

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
${MANUFACTURER}Installation Utility for Linux
__END__
if [ "${OEM}" = "Lexmark" ];then
${CAT_CMD} - << __END__
${COPYRIGHT}
All rights reserved.
__END__
fi
${CAT_CMD} - << __END__
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__END__

if [ "${globalized}" = "true" ]; then
	${ECHO_CMD} "This utility will install PPD files."
else
	${ECHO_CMD} "This utility will install Foomatic files."
fi

if [ -f *EN.txt ]; then
        ${CAT_CMD} *EN.txt
        ${PRINTF_CMD} "\n \n \n"
        ${PRINTF_CMD} "Agree (y|n)? : [y] "
        read x
        if [ "${x}" = "y" ] || [ -z "${x}" ]; then

${CAT_CMD} - << __END__

You will be prompted before installing or replacing
each file.

__END__

        else
                exit;
        fi
else

${CAT_CMD} - << __END__

You will be prompted before installing or replacing
each file.

__END__

	${PRINTF_CMD} "Press ENTER to continue ..."
	read x
fi
}


display_suse_install_selection()
{
${CAT_CMD} - << __END__

---------------------
PPD Install Selection
---------------------
 1.  Common UNIX Print Subsystem (CUPS)
     ----------------------------------
     Select this option if you plan to create and maintain print
     queues with the CUPS Web Interface, CUPS command line tools, 
     KDE Print, or SuSE Yast configuration tool.

 2.  Foomatic drivers
	  ----------------
	  Select this option if you plan to create and maintain print
	  queues with foomatic utilities.

__END__
}

display_redhat_install_selection()
{
${CAT_CMD} - << __END__

---------------------
PPD Install Selection
---------------------
 1.  Common UNIX Print Subsystem (CUPS)
     ----------------------------------
     Select this option if you plan to create and maintain print
     queues with the CUPS Web Interface, CUPS command line tools
     or KDE Print.

 2.  Printer Configuration (printtool or printconf)
     ----------------------------------------------
     Select this option if you plan to create and maintain print
     queues with printool or printconf.

__END__
}

display_other_install_selection()
{
${CAT_CMD} - << __END__

---------------------
PPD Install Selection
---------------------
 1.  Common UNIX Print Subsystem (CUPS)
     ----------------------------------
     Select this option if you plan to create and maintain print
     queues with the CUPS Web Interface, CUPS command line tools
     or KDE Print.

 2.  Foomatic drivers
     ----------------
     Select this option if you plan to create and maintain print
     queues with foomatic utilities.

__END__
}

install_selection()
{
	case ${SYS_TYPE} in
		SUSE)  display_suse_install_selection
				;;
		REDHAT*|FEDORA)
				display_redhat_install_selection
				;;
		*)
				display_other_install_selection
				;;
	esac

	while [ true ]
	do
		${PRINTF_CMD} "Enter your choice : [${PPD_DEFAULT}] "
		read answer
		if [ "${answer}" = "" ];then
			INSTALL_TYPE="${PPD_DEFAULT}"
			break
		elif [ "${answer}" = "1" -o  "${answer}" = "2" ];then
			INSTALL_TYPE="${answer}"
			break
		else
			${ECHO_CMD} "Invalid Selection! "
		fi
	done
	if [ "${answer}" != "" ];then
		PPD_DEFAULT="${answer}"
	fi
	${ECHO_CMD}
}

encode_selection()
{
	${ECHO_CMD}

	if [ "${INSTALL_TYPE}" = "1" ];then	
		if [ "${lang}" = "en" -o "${SHOW_ENC}" = "NO" ];then
                	if [ "${FORCE_ENCODE}" != "YES" ];then
                        	if [ "${SYS_TYPE}" != "SUSE" ];then
                                	encode="ISO8859-1"
                                	return
                        	fi
                	fi
        	fi
	fi

	if [ "${INSTALL_TYPE}" = "2" ];then
		if [ "${SYS_TYPE}" = "REDHAT_3" ];then
			if [ "${FORCE_ENCODE}" != "YES" ];then
				encode="ISO8859-1"
				return
			fi
		elif [ "${SYS_TYPE}" = "REDHAT_4" -o "${SYS_TYPE}" = "FEDORA" -o "${SYS_TYPE}" = "REDHAT_5" ];then
			if [ "${FORCE_ENCODE}" != "YES" ];then
				encode="UTF-8"
				return
			fi
		fi
	fi
	if [ "${SYS_TYPE}" = "SUSE" ];then
		SLINE="queues that work with SuSE Yast and newer CUPS Web Interfaces."
	else
		SLINE="queues that work with newer CUPS Web Interfaces."
	fi

${CAT_CMD} - << __END__

---------------------------
Language Encoding Selection
---------------------------
 1.   Native (ISO8859-1)
      ------------------
      Select this option if your application requires Native
      ISO8859-1 encoded PPDs.

 2.   UTF-8
      -----
      Select this option if your application requires UTF-8 
      encoded PPDs.

NOTE: 
  This option affects how characters are displayed. Some
  applications need ISO8859-1 encoded PPDs, while others need 
  UTF-8 encoded PPDs.  Select the option that best fits your 
  environment.  If you select the wrong encoding for your 
  application, either some characters will not show up or 
  display correctly and/or the application will not create 
  and modify queues correctly.  If this occurs, try re-installing 
  the PPD with the other encoding.

__END__

	while [ true ]
	do
		${PRINTF_CMD} "Enter your choice : [${ENCODE_DEFAULT}] "
      read answer
		if [ "${answer}" = "" ];then
			answer="${ENCODE_DEFAULT}"
			break
		elif [ "${answer}" = "1" -o  "${answer}" = "2" ];then
			break
		else
			${ECHO_CMD} "Invalid Selection! "
		fi
	done
	case ${answer} in
		2) encode="UTF-8"
			;;
		*) encode="ISO8859-1"
			;;
	esac
	if [ "${answer}" != "" ];then
		ENCODE_DEFAULT="${answer}"
	fi
}

lang_selection()
{
	LANG1="English (English):en"
	LANG2="French  (Fraçais):fr"
	LANG3="German  (Deutsch):de"
	LANG4="Italian (Italiano):it"
	LANG5="Brazilian Portuguese (Português do Brasil):pt"
	LANG6="Spanish (Español):es"
	LANG7="Japanese:ja"
	LANG8="Korean:ko"
	LANG9="Simplified Chinese:zh"
	LANG10="Traditional Chinese:zh_TW"

	${ECHO_CMD} "------------------"
	${ECHO_CMD} "Language Selection"
	${ECHO_CMD} "------------------"
	count=1
	num=0
	while [ true ]
	do
		eval LINE="$`${ECHO_CMD} LANG${count}`"
		if [ -z "${LINE}" ];then
			break
		fi
		NAME=`${ECHO_CMD} "${LINE}" | ${AWK_CMD} -F: '{print $1}'`
		NAME_EXT=`${ECHO_CMD} ${LINE} | ${AWK_CMD} -F: '{print $2}'`
		if [ -d "${DEFAULT_ENCODE}/${NAME_EXT}" ];then
			num=`expr ${num} + 1`
			${PRINTF_CMD} " %-3s" "${num}."  
			if [ "${show_utf8}" = "yes" ];then
				${PRINTF_CMD} " ${NAME}\n"
			else 
				${PRINTF_CMD} " `${ECHO_CMD} "${NAME}" | ${ICONV_CMD} -f UTF-8 -t ISO8859-1`\n"
			fi
			eval num_${num}="${NAME_EXT}"
		fi
		count=`expr ${count} + 1`
	done
	${ECHO_CMD}

	while [ true ]
	do
		${PRINTF_CMD} "Enter your choice : [${LANG_DEFAULT}] "
		read answer

		#-- Check for blank or default value
		${ECHO_CMD} "${answer}" | ${EGREP_CMD} "  *" >/dev/null 2>&1
		if [ "${?}" = "0" ] || [ -z "${answer}" ];then
			answer="${LANG_DEFAULT}"
		fi

		#-- Make sure answer is a number.
		${ECHO_CMD} "${answer}" | ${EGREP_CMD} "^[0-9][0-9]*$" >/dev/null 2>&1
		if [ "${?}" != "0" ];then
			${PRINTF_CMD} "Invalid Selection! "
			continue
		fi

		#-- Make sure answer is a valid option.
		if [ ${answer} -lt 1 -o ${answer} -gt ${num} ];then
			${PRINTF_CMD} "Invalid Selection! "
			continue
		else 
			break
		fi
	done

	eval lang=$`${ECHO_CMD} num_${answer}`		
	if [ "${answer}" != "" ];then
		LANG_DEFAULT=${answer}
	fi
}

is_cupsd_running ()
{
   PID=`${PS_CMD} auxw | ${GREP_CMD} cupsd | ${GREP_CMD} -v grep | ${AWK_CMD} '{print $2}'`
   if [ -z "${PID}" ]; then 
		return 1
	fi
}

restart_cups()
{
	is_cupsd_running
	if [ $? -eq 1 ];then
		return
	fi

	PATH=/sbin:/usr/sbin:$PATH ; export PATH
	${ECHO_CMD}

	while [ true ] 
	do
		${PRINTF_CMD} "Restart CUPS to complete the installation (y|n)? : [y] "
		read answer
		if [ "${answer}" = "y" ] || [ -z "${answer}" ];then
			if [ -f /etc/init.d/cupsys ];then
				/etc/init.d/cupsys restart
			elif [ -f /etc/init.d/cups ];then
				/etc/init.d/cups restart
			else
				service cups restart
			fi
			break;
		elif [ "${answer}" = "n" ];then
			${ECHO_CMD} "   Skipped at user request."
			${ECHO_CMD} "   Note: CUPS must be restarted for changes to take affect."
			break;
		else
			continue;
		fi
	done
}


update_driver_xml()
{
	if [ ! -f "${FOO_DRV_DIR}/${OEM}_PPD.xml" ];then
		{
			${ECHO_CMD} "<driver id=\"driver/${OEM}_PPD\">"
 			${ECHO_CMD} "  <name>${OEM}_PPD</name>"
 			${ECHO_CMD} "  <url>${URL}</url>"
			${ECHO_CMD} "  <execution>"
			${ECHO_CMD} "    <postscript/>"
			${ECHO_CMD} "    <prototype>cat %A%Z</prototype>"
			${ECHO_CMD} "  </execution>"
			${ECHO_CMD} "  <comments>"
			${ECHO_CMD} "    <de>Foomatic Driver Converted from ${OEM} PPD</de>"
			${ECHO_CMD} "    <en>Foomatic Driver Converted from ${OEM} PPD</en>"
			${ECHO_CMD} "    <es>Foomatic Driver Converted from ${OEM} PPD</es>"
			${ECHO_CMD} "    <fr>Foomatic Driver Converted from ${OEM} PPD</fr>"
			${ECHO_CMD} "    <pt>Foomatic Driver Converted from ${OEM} PPD</pt>"
			${ECHO_CMD} "    <it>Foomatic Driver Converted from ${OEM} PPD</it>"
			${ECHO_CMD} "  </comments>"
			${ECHO_CMD} "  <printers>"
			${ECHO_CMD} "  </printers>"
			${ECHO_CMD} "</driver>"
		} > ${FOO_DRV_DIR}/${OEM}_PPD.xml 
	fi
	${GREP_CMD} ${FILE} ${FOO_DRV_DIR}/${OEM}_PPD.xml >/dev/null 2>&1
	if [ $? -ne 0 ];then
		GrepOut=`${GREP_CMD} -n "</printers>" ${FOO_DRV_DIR}/${OEM}_PPD.xml 2>&1`
		LINE=`${ECHO_CMD} ${GrepOut} | ${AWK_CMD} -F: '{print $1}'`
		INFO="\ \ \  <printer><id>printer/${FILE}</id></printer>"
		${CAT_CMD} ${FOO_DRV_DIR}/${OEM}_PPD.xml | ${SED_CMD} -e "${LINE}i  ${INFO}" > ${FOO_DRV_DIR}/${OEM}_PPD.xml.tmp
		${CP_CMD} -f ${FOO_DRV_DIR}/${OEM}_PPD.xml.tmp ${FOO_DRV_DIR}/${OEM}_PPD.xml
		${RM_CMD} -f ${FOO_DRV_DIR}/${OEM}_PPD.xml.tmp
	fi
}







#--
#-- The Script starts here  ....
#--
#-- parse arguments begin
while [ ! -z "${1}" ]
do
	case "${1}" in
		--foo)		FORCE_FOO="YES"
						;;
		--encode)	FORCE_ENCODE="YES"
						;;
		--localized)	FORCE_LOCALPPD="YES"
						  ;;
	esac
	shift 1
done

initialize_variables
get_cups_version
clear
check_for_root
check_for_cups
display_header
set_ppd

if [ "${globalized}" = "false" ];then


	###########################
	# Installing localized ppd
	###########################
	change_to_install_dir

	while [ true ] 
	do
		continue1=no
		continue2=no

		#-- Check for Redhat & Foomatic directories 
		#if [ -d "${FOO_DRV_DIR}" -a -d "${FOO_PRT_DIR}" ];then
		#	if [ "${SHOW_FOO}" = "YES" -o "${FORCE_FOO}" = "YES" ];then
		#		install_selection
		#	fi
		#fi

		INSTALL_TYPE="2"
	
		if [ "${INSTALL_TYPE}" = "2" ];then
		# 	lang_selection	
		#	no need to call lang_selection since we only have one language (EN) in package
			LANG_DEFAULT="1"
			lang="en"
			encode_selection
		fi


		for i in ${PREDEF_FILES_FOO}
		do

                        FILE_XML="${i}_${lang}.xml"

                        FILE="${i}"
                        FILE_PPD="${i}.ppd"
                        SFILE_PPD="${i}.ppd"
                        FILE_PATH="${GLOBALDIR}/${FILE_PPD}"
	
			#model=`${EGREP_CMD} "\*NickName:" ${FILE_PATH}`
			#model=`${ECHO_CMD} "${model}" | ${AWK_CMD} -F\" '{print $2}'`

			#while [ true ]
			#do
			#	if [ "${show_utf8}" = "no" -a "${encode}" = "UTF-8" ];then
			#		${PRINTF_CMD} "Install [ `${ECHO_CMD} "${model}" | ${ICONV_CMD} -f UTF-8 -t ISO8859-1` ] ? "
			#	elif [ "${show_utf8}" = "yes" -a "${encode}" != "UTF-8" ];then
			#		${PRINTF_CMD} "Install [ `${ECHO_CMD} "${model}" | ${ICONV_CMD} -f ISO8859-1 -t UTF-8` ] ? "
			#	else
			#		${PRINTF_CMD} "Install [ ${model} ] ? "
			#	fi
			#	confirm_user 
	
			#	if [ "${rc}" != "-1" ]; then
			#		break;
			#	fi
			#done
	
			#if [ "${rc}" = "1" ]; then
				if [ -f "${FOO_PRT_DIR}/${FILE_XML}" ]; then
					while [ true ]
					do
						${ECHO_CMD} "    WARNING:"
						${ECHO_CMD} "       This printer already exists on your system .."
						confirm_user 1 
	
						if [ "${rc}" != "-1" ]; then
							break;
						fi
					done
					if [ "${rc}" != "1" ]; then
						${ECHO_CMD} "Skipped at user request."
						continue
					fi
				fi
				FILE_XML="${i}_${lang}.xml"
				FILE="${i}_${lang}"
				${PRINTF_CMD} "    Installing ${FILE} ... "
				${RM_CMD} -f ${FOO_PRT_DIR}/${FILE_XML}
				${RM_CMD} -f ${FOO_OPT_DIR}/ppd-${FILE}*
				${CAT_CMD} foomatic/${encode}/foomatic.tar | { cd ${FOO_DIR}; tar xf - printer/${FILE_XML}; }
	
				if [ -f "/etc/debian_version" ]; then
				        ${CAT_CMD} foomatic/${encode}/foomatic.tar | { cd ${FOO_DIR}; tar --wildcards -xf - opt/ppd-${FILE}*; }
				else
				        ${CAT_CMD} foomatic/${encode}/foomatic.tar | { cd ${FOO_DIR}; tar xf - opt/ppd-${FILE}*; }
				fi

				update_driver_xml
				${ECHO_CMD} "Done"
			#else
			#	${ECHO_CMD} "    Skipped at user request."
			#fi
		done

		################################################################
		#
		# Part where it ask if the user wants to install additional ppd
		#
		################################################################
		#while [ true ]
		#do
		#	${PRINTF_CMD} "Install Additional PPDs (y|n)? : [n] "
		#	read answer
		#	${ECHO_CMD} ${answer} | ${EGREP_CMD} "^yes$|^y$|^no$|^n$" >/dev/null 2>&1
		#
		#	if [ $? -eq 0 ] || [ "${answer}" == "" ];then
		#		break		
		#	fi
		#
		#done
	
		break
	
		${ECHO_CMD} ${answer} | ${EGREP_CMD} "^yes$|^y$" >/dev/null 2>&1
		if [ $? -ne 0 ];then
			break		
		fi
	
	done


else	
	##########################
	# installing globalized
	##########################
	${ECHO_CMD} ""

	INSTALL_TYPE="1"
	
	PSTOPDF="false"
        if [ -f "/usr/lib/cups/filter/pstopdf" ]; then
            PSTOPDF="true"
	else
 	    PSTOPDF="false"
        fi


	CONTONESUPPORT="false"
        for i in ${PREDEF_FILES}
	do
		${ECHO_CMD} "${i}" | ${GREP_CMD} "Postscript" >/dev/null 2>&1
   		if [ $? -ne 0 ]; then 
                        CONTONESUPPORT="false"
                else
                        CONTONESUPPORT="true"
                        
			break;
                fi
        done
         
        #TODO: Refactor
	
	for i in ${PREDEF_FILES}
	do
		if [ "${CONTONESUPPORT}" = "true" ]; then
                        ${ECHO_CMD} "${i}" | ${GREP_CMD} "Postscript" >/dev/null 2>&1
   			if [ $? -ne 0 ]; then 
				#ppdfile: contone
                                if [ ${ISCUPS14} = "true" ]; then
                        		if [ "${PSTOPDF}" = "true" ]; then
						FILE_PPD="${i}.ppd"
						if [ -f "${DEST_PPD_DIR}/${FILE_PPD}" ]; then
							while [ true ]
							do
								${ECHO_CMD} "    WARNING:"
								${ECHO_CMD} "       This printer already exists on your system .."
								confirm_user 1 
	
								if [ "${rc}" != "-1" ]; then
									break;
								fi
							done
							if [ "${rc}" != "1" ]; then
								${ECHO_CMD} "Skipped at user request."
								continue
							fi
						fi
						
						${PRINTF_CMD} "    Installing ${FILE_PPD} ... "
						if [ ! -d "${DEST_PPD_DIR}" ];then
							mkdir -p ${DEST_PPD_DIR}
						fi
		
						${CP_CMD} ${GLOBALDIR}/${FILE_PPD} ${DEST_PPD_DIR}/${FILE_PPD}
						${CHMOD_CMD} ${PPD_PERMS} ${DEST_PPD_DIR}/${FILE_PPD}
                                                
                                                # For Ubuntu OS only, remove *cupsFilter: "application/pdf 0 /usr/lib/cups/filter/pdftocontone" 
                                                # in PPD file in order to print via commandline printing
                                                if [ "${SYS_TYPE}" = "UBUNTU" ];then
                                                    ${CAT_CMD} ${DEST_PPD_DIR}/${FILE_PPD} | ${SED_CMD} '/\*cupsFilter: \"application\/pdf 0 \/usr\/lib\/cups\/filter\/pdftocontone\"/ d' > ${DEST_PPD_DIR}/${FILE_PPD}.tmp
                                                    ${CP_CMD} -f ${DEST_PPD_DIR}/${FILE_PPD}.tmp ${DEST_PPD_DIR}/${FILE_PPD}
                                                    ${RM_CMD} -f ${DEST_PPD_DIR}/${FILE_PPD}.tmp
                                                fi 
				
						# Check if 64Bit or 32Bit Machine
						MACHINE_TYPE_A=`uname -m`
						MACHINE_TYPE_B=`uname -i`

						if [ ${MACHINE_TYPE_A} = 'x86_64' -o ${MACHINE_TYPE_B} = 'x86_64' ]; then
                                           		${CP_CMD} ${GLOBALDIR14}/${CONTONE_FILTERDIR_LIB64}/${CONTONEFILTER} ${DEST_FAX_PNH_DIR}
				        	else
					   		${CP_CMD} ${GLOBALDIR14}/${CONTONE_FILTERDIR_LIB}/${CONTONEFILTER} ${DEST_FAX_PNH_DIR}
                                        	fi

						${ECHO_CMD} "Done"
                                        fi
                                else
                                       	continue;
                                fi

                                if [ ${CUPS_VERSION} -ge 4 ]; then
					#copy lexmark.convs file to /usr/share/cups/mime
                			${CP_CMD} ${GLOBALDIR14}/${LEX_CONVS} ${DEST_LEX_CONVS_DIR}
				fi
                        else
 				#ppdfile: postscript
                                if [ ${ISCUPS14} = "true" ]; then
					if [ "${PSTOPDF}" = "true" ]; then
						continue;
             				else
                                		FILE_PPD="${i}.ppd"
                                        	if [ -f "${DEST_PPD_DIR}/${FILE_PPD}" ]; then
							while [ true ]
							do
								${ECHO_CMD} "    WARNING:"
								${ECHO_CMD} "       This printer already exists on your system .."
								confirm_user 1 
	
								if [ "${rc}" != "-1" ]; then
									break;
								fi
							done
							if [ "${rc}" != "1" ]; then
								${ECHO_CMD} "Skipped at user request."
								continue
							fi
						fi
						${PRINTF_CMD} "    Installing ${FILE_PPD} ... "
						if [ ! -d "${DEST_PPD_DIR}" ];then
							mkdir -p ${DEST_PPD_DIR}
						fi
		
						${CP_CMD} ${GLOBALDIR}/${FILE_PPD} ${DEST_PPD_DIR}/${FILE_PPD}
						${CHMOD_CMD} ${PPD_PERMS} ${DEST_PPD_DIR}/${FILE_PPD}
						${ECHO_CMD} "Done"
                               	 	fi
                                else
                                	FILE_PPD="${i}.ppd"
                                        if [ -f "${DEST_PPD_DIR}/${FILE_PPD}" ]; then
						while [ true ]
						do
							${ECHO_CMD} "    WARNING:"
							${ECHO_CMD} "       This printer already exists on your system .."
							confirm_user 1 
	
							if [ "${rc}" != "-1" ]; then
							break;
							fi
						done
						if [ "${rc}" != "1" ]; then
							${ECHO_CMD} "Skipped at user request."
							continue
						fi
					fi
					${PRINTF_CMD} "    Installing ${FILE_PPD} ... "
					if [ ! -d "${DEST_PPD_DIR}" ];then
						mkdir -p ${DEST_PPD_DIR}
					fi
		
					${CP_CMD} ${GLOBALDIR}/${FILE_PPD} ${DEST_PPD_DIR}/${FILE_PPD}
					${CHMOD_CMD} ${PPD_PERMS} ${DEST_PPD_DIR}/${FILE_PPD}
					${ECHO_CMD} "Done"
                                fi
                        fi
                else
                	FILE_PPD="${i}.ppd"

			if [ -f "${DEST_PPD_DIR}/${FILE_PPD}" ]; then
				while [ true ]
				do
					${ECHO_CMD} "    WARNING:"
					${ECHO_CMD} "       This printer already exists on your system .."
					confirm_user 1 
	
					if [ "${rc}" != "-1" ]; then
						break;
					fi
				done
				if [ "${rc}" != "1" ]; then
					${ECHO_CMD} "Skipped at user request."
					continue
				fi
			fi
			${PRINTF_CMD} "    Installing ${FILE_PPD} ... "
			if [ ! -d "${DEST_PPD_DIR}" ];then
				mkdir -p ${DEST_PPD_DIR}
			fi
		
			${CP_CMD} ${GLOBALDIR}/${FILE_PPD} ${DEST_PPD_DIR}/${FILE_PPD}
			${CHMOD_CMD} ${PPD_PERMS} ${DEST_PPD_DIR}/${FILE_PPD}
			${ECHO_CMD} "Done"
                fi
		
	done
	
	if [ ${CUPS_VERSION} -ge 4 ]; then
		#copy fax and print and hold filter to /usr/lib/cups/filter and set it to executable
                if [ -f "${GLOBALDIR14}/${FAXPNHFILTER}" ]; then
       		    ${CP_CMD} ${GLOBALDIR14}/${FAXPNHFILTER} ${DEST_FAX_PNH_DIR}
		    ${CHMOD_CMD} 755 ${DEST_FAX_PNH_DIR}/${FAXPNHFILTER}
                fi

                if [ -f "${GLOBALDIR14}/${REROUTEFILTER}" ]; then
       		    ${CP_CMD} ${GLOBALDIR14}/${REROUTEFILTER} ${DEST_FAX_PNH_DIR}
		    ${CHMOD_CMD} 755 ${DEST_FAX_PNH_DIR}/${REROUTEFILTER}
                fi
		#copy Command File Filter to /usr/lib/cups/filter and set it to executable
                # Check if 64Bit or 32Bit Machine
                MACHINE_TYPE_A=`uname -m`
                MACHINE_TYPE_B=`uname -i`

               if [ ${MACHINE_TYPE_A} = 'x86_64' -o ${MACHINE_TYPE_B} = 'x86_64' ]; then
                   ${CP_CMD} ${GLOBALDIR14}/lib64/${CMDFILEFILTER} ${DEST_FAX_PNH_DIR}
	   	   if [ -f ${GLOBALDIR14}/lib64/${HBPFILTER} ]; then
           	   	${CP_CMD} ${GLOBALDIR14}/lib64/${HBPFILTER} ${DEST_FAX_PNH_DIR}
           	        ${CHMOD_CMD} 755 ${DEST_FAX_PNH_DIR}/${HBPFILTER}
	   	   fi
               else
                   ${CP_CMD} ${GLOBALDIR14}/lib/${CMDFILEFILTER} ${DEST_FAX_PNH_DIR}
	   	   if [ -f ${GLOBALDIR14}/lib/${HBPFILTER} ]; then
           	   	${CP_CMD} ${GLOBALDIR14}/lib/${HBPFILTER} ${DEST_FAX_PNH_DIR}
           	        ${CHMOD_CMD} 755 ${DEST_FAX_PNH_DIR}/${HBPFILTER}
	   	   fi
               fi

               ${ECHO_CMD} "Done"

               ${CHMOD_CMD} 755 ${DEST_FAX_PNH_DIR}/${CMDFILEFILTER}
               #copy lexmark.convs file to /usr/share/cups/mime gsantos
               #${CP_CMD} ${GLOBALDIR14}/${LEX_CONVS} ${DEST_LEX_CONVS_DIR}
	fi
	
	PPD_WAS_INSTALLED="yes"

fi

if [ "${PPD_LINK}" = "YES" ]; then
        if [ "${INSTALL_TYPE}" = "1" ]; then
                if [ -d "/usr/share/cups/model/" ]; then
                    if [ -d "/usr/share/ppd/${OEM_DEST}_PPD" ]; then
                        ${RM_CMD} -rf /usr/share/cups/model/${OEM_DEST}_PPD
                        ${CP_CMD} -r /usr/share/ppd/${OEM_DEST}_PPD /usr/share/cups/model
                    fi 
                fi      
        fi
fi  

if [ "${PPD_WAS_INSTALLED}" = "yes" ];then
		restart_cups
fi

${ECHO_CMD}
${ECHO_CMD} "Installation complete."
${ECHO_CMD}
exit
